package com.hero.objects.disads;

import org.jdom.Element;

import com.hero.objects.Adder;
import com.hero.objects.modifiers.Modifier;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class Hunted extends Disadvantage {

    public Hunted(Element root) {
        super(root);
    }

    @Override
    public String getColumn2Output() {
        String ret = getAlias();
        ret += ": ";
        int count = 0;
        for (Modifier mod : getAssignedModifiers()) {
            count++;
            String adderString = "";
            String modString = "";
            if (count > 0) {
                modString += ", ";
            } else {
                modString = " ";
            }
            double val = mod.getTotalValue();
            for (Adder ad : mod.getAssignedAdders()) {
                if (adderString.length() > 0) {
                    adderString += ", ";
                }
                adderString += ad.getAlias();
                val -= ad.getBaseCost();
            }
            if (mod.getInput() != null && mod.getInput().trim().length() > 0) {
                if (modString.trim().length() > 0) {
                    modString += ":  ";
                }
                modString += mod.getInput();
            }
            for (Modifier mod2 : mod.getAssignedModifiers()) {
                modString += ", " + mod2.getAlias();
            }

            if (mod.getSelectedOption() != null) {
                modString += mod.getSelectedOption().getAlias();
            }
            if (adderString.trim().length() > 0) {
                if (modString.trim().length() > 0) {
                    modString += ", ";
                }
                modString += adderString;
            }
            if (modString.trim().length() > 0) {
                ret += modString;
            }
        }
        if (getInput() != null && getInput().trim().length() > 0) {
            ret += " " + getInput();
        }
        int numParens = 0;
        count = 0;
        for (Adder ad : getAvailableAdders()) {
            count++;
            if (!getAssignedAdders().contains(ad)) {
                continue;
            }
            ad = getAssignedAdders().get(getAssignedAdders().indexOf(ad));
            if (ad.getXMLID().equals("NCI")
                    && ad.getDisplay().equals(ad.getAlias())) {
                ad.setAlias("NCI");
            }
            if (ad.isRequired() && ad.getSelectedOption() != null
                    && ad.getSelectedOption().getAlias().trim().length() > 0) {
                if (ad.getSelectedOption().getAlias().trim().startsWith("(")) {
                    ret += " ";
                    if (ad.getSelectedOption().getAlias().indexOf(")") < 0) {
                        numParens++;
                    }
                } else if (count == 1) {
                    ret += " ";
                } else if (numParens > 0) {
                    ret += getAdderSeparator() + " ";
                } else {
                    ret += ", ";
                }
                ret += ad.getSelectedOption().getAlias();
            } else if (!ad.isRequired()) {
                String alias = ad.getAlias();
                if (ad.getSelectedOption() != null) {
                    if (alias.trim().length() > 0) {
                        alias += ":  ";
                    }
                    alias += ad.getSelectedOption().getAlias();
                }
                if (ad.getInput() != null && ad.getInput().trim().length() > 0) {
                    if (alias.trim().length() > 0) {
                        alias += ":  ";
                    }
                    alias += ad.getInput();
                }
                if (alias.trim().length() == 0) {
                    continue;
                }
                if (alias.trim().startsWith("(")) {
                    ret += " ";
                    if (alias.indexOf(")") < 0) {
                        numParens++;
                    }
                } else if (count == 1) {
                    ret += " ";
                } else if (numParens > 0) {
                    ret += getAdderSeparator() + " ";
                } else {
                    ret += ", ";
                }
                ret += alias;
            }
        }
        count = 0;
        for (Adder ad : getAssignedAdders()) {
            count++;
            if (getAvailableAdders().contains(ad)) {
                continue;
            }
            String alias = ad.getAlias();
            if (ad.getSelectedOption() != null) {
                if (alias.trim().length() > 0) {
                    alias += ":  ";
                }
                alias += ad.getSelectedOption().getAlias();
            }
            if (ad.getInput() != null && ad.getInput().trim().length() > 0) {
                if (alias.trim().length() > 0) {
                    alias += ":  ";
                }
                alias += ad.getInput();
            }
            if (alias.trim().length() == 0) {
                continue;
            }
            if (alias.trim().startsWith("(")) {
                ret += " ";
                if (alias.indexOf(")") < 0) {
                    numParens++;
                }
            } else if (count == 1) {
                ret += " ";
            } else if (numParens > 0) {
                ret += getAdderSeparator() + " ";
            } else {
                ret += ", ";
            }
            ret += alias;
        }

        while (numParens > 0) {
            ret += ")";
            numParens--;
        }
        if (ret.trim().endsWith(":")) {
            ret = ret.trim();
            ret = ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

}
